package cn.com.duiba.quanyi.center.api.remoteservice.insurance.cdtb;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.insurance.cdtb.InsurancePhoneMatchDto;
import cn.com.duiba.quanyi.center.api.param.insurance.cdtb.InsurancePhoneMatchSearchParam;
import java.util.List;

/**
 * 保险手机号加密匹配表
 * @author kjj mybatis generator 
 * @date 2024-09-25
 */
@AdvancedFeignClient
public interface RemoteInsurancePhoneMatchService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 保险手机号加密匹配集合
     */
    List<InsurancePhoneMatchDto> selectPage(InsurancePhoneMatchSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(InsurancePhoneMatchSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 保险手机号加密匹配
     */
    InsurancePhoneMatchDto selectById(Long id);

    /**
     * 新增
     * @param dto 保险手机号加密匹配
     * @return 执行结果
     */
    int insert(InsurancePhoneMatchDto dto);

    /**
     * 更新
     * @param dto 保险手机号加密匹配
     * @return 影响行数
     */
    int update(InsurancePhoneMatchDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}