package cn.com.duiba.quanyi.center.api.remoteservice.youjia;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.youjia.WxCouponBillYjDto;

import java.util.List;

/**
 * 优加微信立减金账单明细服务
 * 
 * @author cxw
 * @date 2025-10-30 15:00
 */
@AdvancedFeignClient
public interface RemoteWxCouponBillYjService {

    /**
     * 根据微信券ID和批次号查询账单信息
     *
     * @param wxCouponId 微信返回的券ID
     * @param stockId 微信批次号
     * @return 账单明细信息集合
     */
    List<WxCouponBillYjDto> selectByWxCouponIdAndStockId(String wxCouponId, String stockId);
}

