package cn.com.duiba.quanyi.center.api.param.deposit;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;

/**
 * 保证金表查询参数
 * @author xuzhigang
 * @date 2025-01-21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class PaymentInfoDepositSearchParam extends PageQuery {

    private static final long serialVersionUID = 1L;

    /**
     * 投标名称，最多20字
     */
    private String bidName;

    /**
     * 保证金id集合 tb_demand_payment_info.id
     */
    private List<Long> paymentInfoIds;

    /**
     * 保证金状态
     */
    private List<Integer> depositStatuseList;

    /**
     * 关联合同id集合
     */
    private List<Long> contractIdList;

    /**
     * 招标单位名称
     */
    private String tenderUnitName;

    /**
     * 招标代理公司
     */
    private String bidAgentCompany;

    /**
     * 保证金类型
     * @see cn.com.duiba.quanyi.center.api.enums.payment.PaymentInfoDepositTypeEnum
     */
    private Integer depositType;
}
