package cn.com.duiba.quanyi.center.api.dto.activity.common.cache;

import java.io.Serializable;

import lombok.Data;

/**
 * 用户领取记录统计缓存DTO
 * 
 * @author lizhi
 * @date 2025/5/12 14:56
 */
@Data
public class UserTakeStatCacheDto implements Serializable {

    private static final long serialVersionUID = -6620632903052510397L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 奖品ID
     */
    private Long prizeId;

    /**
     * 已领取次数
     */
    private Long takeCount;

    /**
     * 最后一次领取记录ID
     */
    private Long lastRecordId;

    /**
     * 已参与的活动ID，下划线分割
     */
    private String takeActivityIds;

    /**
     * 维度类型
     * @see cn.com.duiba.quanyi.center.api.enums.activity.MultiSelectNDimensionEnum
     * 0-永久，1-日，2-自然周，3-自然月，4-自然季度，5-自定义
     */
    private Integer dimension;

    /**
     * 周期标识
     * 永久（不限制）：0
     * 日维度：20250120
     * 自然周：2025W03
     * 自然月：202512
     * 自然季度：2025Q4
     * 自定义：custom_yyyymmdd-yyyymmdd（在有效期内）或0（不在有效期内）
     */
    private String dimensionPeriod;
}
