package cn.com.duiba.quanyi.center.api.remoteservice.activity.take;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.common.cache.UserTakeStatCacheDto;

/**
 * 用户领取记录统计
 * @author kjj mybatis generator
 * @date 2025-04-21
 */
@AdvancedFeignClient
public interface RemoteUserTakeStatService {

    /**
     * 根据用户及活动查询
     * @param userId 用户ID
     * @param activityId 活动ID
     * @return 用户领取记录统计
     */
    List<UserTakeStatCacheDto> selectByUserActCache(Long userId, Long activityId);

    /**
     * 根据用户及集合页查询（自动获取维度配置）
     * @param userId 用户ID
     * @param collectionPageId 集合页ID
     * @return 用户领取记录统计
     */
    UserTakeStatCacheDto selectByUserCollectionPageCache(Long userId, Long collectionPageId);

    /**
     * 初始化用户领取记录统计
     * @param userId 用户ID
     * @param activityId 活动ID
     * @param collectionPageId 集合页ID
     * @return 执行结果
     */
    int initUserStatActivity(Long userId, Long activityId, Long collectionPageId);

    /**
     * 根据用户及集合页查询列表（返回当前维度时间内的所有记录）
     * @param userId 用户ID
     * @param collectionPageId 集合页ID
     * @return 用户领取记录统计列表（仅包含当前维度时间内的数据）
     */
    List<UserTakeStatCacheDto> selectListByUserCollectionPageCache(Long userId, Long collectionPageId);
}
