package cn.com.duiba.quanyi.center.api.dto.activity.common.cache;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import cn.com.duiba.quanyi.center.api.dto.activity.common.cache.collection.ActivityCommonUserApiVerifyCollectionPageDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.cache.collection.ActivityCommonUserCustomVerifyCollectionPageDto;
import cn.com.duiba.quanyi.center.api.dto.pay.PayOrderDto;
import cn.com.duiba.quanyi.center.api.dto.user.UserDto;
import cn.com.duiba.quanyi.center.api.utils.SerializableOptional;
import lombok.Data;

/**
 * @author lizhi
 * @date 2025/4/14 16:47
 */
@Data
public class ActivityCommonUserInfoCacheDto implements Serializable{

    private static final long serialVersionUID = -5248072315758299658L;

    /**
     * 领取记录
     */
    private List<ActivityPrizeReceiveRecordCacheDto> receiveRecordList;

    /**
     * 领取记录统计数据
     */
    private List<UserTakeStatCacheDto> userTakeStatList;

    /**
     * 用户
     */
    private UserDto userDto;

    /**
     * 用户扩展信息缓存
     */
    private Map<Integer, String> userExtMap;

    /**
     * 用户身份校验结果（API）
     */
    private ActivityCommonUserApiVerifyDto userApiVerify;

    /**
     * 用户身份校验结果（定制校验）
     */
    private ActivityCommonUserCustomVerifyDto userCustomVerify;

    /**
     * 达标等级（API）
     */
    private ActivityCommonReachStandardDto apiReachStandard;

    /**
     * 报名记录
     */
    private List<ActivitySignUpCacheDto> signUpList;

    /**
     * 报名定制校验结果
     */
    private ActivityCommonCustomSignUpVerifyDto customSignUpVerify;

    /**
     * 最近一次处理中支付记录-为null时说明没有命中缓存
     */
    private SerializableOptional<PayOrderDto> lastPayOrderOptional;

    /**
     * 可使用的支付领取凭证
     */
    private List<PayOrderTakeVoucherCacheDto> payOrderVoucherList;

    /**
     * 集合页-领取记录统计数据(不包含活动ID)
     * @deprecated 已废弃，请使用userTakeStatCollectionPageList，支持多分组场景
     */
    @Deprecated
    private SerializableOptional<UserTakeStatCacheDto> userTakeStatCollectionPageOptional;

    /**
     * 集合页-领取记录统计数据列表（支持多分组场景）
     * 一个集合页可能有多个活动分组，每个分组都有独立的统计记录
     */
    private List<UserTakeStatCacheDto> userTakeStatCollectionPageList;

    /**
     * 集合页-用户身份校验结果（API）
     */
    private ActivityCommonUserApiVerifyCollectionPageDto userApiVerifyCollectionPage;

    /**
     * 集合页-用户身份校验结果（定制校验）
     */
    private ActivityCommonUserCustomVerifyCollectionPageDto userCustomVerifyCollectionPage;

    /**
     * 集合页-报名记录
     */
    private List<ActivitySignUpCacheDto> signUpListCollectionPage;
}
