package cn.com.duiba.quanyi.center.api.remoteservice.activity.take;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.common.cache.UserTakeStatCacheDto;

/**
 * 用户领取记录统计
 * @author kjj mybatis generator
 * @date 2025-04-21
 */
@AdvancedFeignClient
public interface RemoteUserTakeStatService {

    /**
     * 根据用户及活动查询
     * @param userId 用户ID
     * @param activityId 活动ID
     * @return 用户领取记录统计
     */
    List<UserTakeStatCacheDto> selectByUserActCache(Long userId, Long activityId);

    /**
     * 根据用户及集合页查询列表（支持多分组场景）
     * @param userId 用户ID
     * @param collectionPageId 集合页ID
     * @return 用户领取记录统计列表
     */
    List<UserTakeStatCacheDto> selectByUserCollectionPageListCache(Long userId, Long collectionPageId);

    /**
     * 根据用户及集合页查询（自动获取维度配置）
     * @param userId 用户ID
     * @param collectionPageId 集合页ID
     * @return 用户领取记录统计
     * @deprecated 已废弃，请使用selectByUserCollectionPageListCache，支持多分组场景
     */
    @Deprecated
    UserTakeStatCacheDto selectByUserCollectionPageCache(Long userId, Long collectionPageId);

    /**
     * 初始化用户领取记录统计(旧分组模式，不推荐使用，废弃方法，使用initUserStatActivityNew)
     * @param userId 用户ID
     * @param activityId 活动ID
     * @param collectionPageId 集合页ID
     * @return 执行结果
     */
    @Deprecated
    int initUserStatActivity(Long userId, Long activityId, Long collectionPageId);

    /**
     * 初始化用户领取记录统计（新分组模式)
     * @param userId 用户ID
     * @param activityId 活动ID
     * @param collectionPageId 集合页ID
     * @return 执行结果
     */
    int initUserStatActivityNew(Long userId, Long activityId, Long collectionPageId);
}
