package cn.com.duiba.quanyi.center.api.dto.api.doc.result;

import lombok.Data;

import java.io.Serializable;

/**
 * API文档-订单结果
 * @author lizhi
 * @date 2024/7/17 10:06
 */
@Data
public class ApiDocOrderResultDto implements Serializable {
    
    private static final long serialVersionUID = 3646836594698630416L;

    /**
     * 三方订单号，下单时传递，兑吧透传返回
     */
    private String thirdOrderId;

    /**
     * 开发者自有参数，兑吧透传
     */
    private String remark;

    /**
     * 公众号H5静默授权领取链接，微信立减金/到零钱链接券时有值
     */
    private String oaLink;

    /**
     * 小程序H5唤起授权领取链接，微信立减金/到零钱链接券时有值
     */
    private String mpLink;

    /**
     * 小程序AppID，微信立减金/到零钱链接券时有值
     */
    private String mpAppId;

    /**
     * 小程序Path，微信立减金/到零钱链接券时有值
     */
    private String mpPath;

    /**
     * 支付宝领取链接, 支付宝立减金，链接券时有值
     */
    private String alipayLink;

    /**
     * 失效时间, 时间戳
     */
    private Long expireTime;

    /**
     * 最后更新时间, 时间戳
     */
    private Long lastTime;

    /**
     * 通用直冲类型短链
     */
    private String generalLink;

    /**
     * 短链接
     */
    private String shortUrl;
}
