/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.utils.activity;

import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.collection.ActivityCommonCollectionPageParticipateLimitConfDto;
import cn.com.duiba.quanyi.center.api.enums.activity.MultiSelectNDimensionEnum;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DimensionValueUtils {
    public static String calculateDimensionValue(Integer dimension, Date date, ActivityCommonCollectionPageParticipateLimitConfDto dimensionConf) {
        String period;
        if (dimension == null) {
            return "0";
        }
        Date targetDate = date != null ? date : new Date();
        MultiSelectNDimensionEnum dimensionEnum = MultiSelectNDimensionEnum.getByCode(dimension);
        if (dimensionEnum == null) {
            return "0";
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(targetDate);
        int year = calendar.get(1);
        switch (dimensionEnum) {
            case PERMANENT: {
                period = "0";
                break;
            }
            case DAY: {
                SimpleDateFormat dayFormat = new SimpleDateFormat("yyyyMMdd");
                period = dayFormat.format(targetDate);
                break;
            }
            case WEEK: {
                int weekOfYear = calendar.get(3);
                period = String.format("%dW%02d", year, weekOfYear);
                break;
            }
            case MONTH: {
                int month = calendar.get(2) + 1;
                period = String.format("%d%02d", year, month);
                break;
            }
            case QUARTER: {
                int monthForQuarter = calendar.get(2) + 1;
                int quarter = (monthForQuarter - 1) / 3 + 1;
                period = String.format("%dQ%d", year, quarter);
                break;
            }
            case CUSTOM: {
                if (dimensionConf != null && dimensionConf.getCustomStartTime() != null && dimensionConf.getCustomEndTime() != null) {
                    Date startTime = dimensionConf.getCustomStartTime();
                    Date endTime = dimensionConf.getCustomEndTime();
                    if (targetDate.compareTo(startTime) >= 0 && targetDate.compareTo(endTime) <= 0) {
                        SimpleDateFormat customFormat = new SimpleDateFormat("yyyyMMdd");
                        period = "custom_" + customFormat.format(startTime) + "-" + customFormat.format(endTime);
                        break;
                    }
                    period = "0";
                    break;
                }
                period = "0";
                break;
            }
            default: {
                period = "0";
            }
        }
        return period != null ? period : "0";
    }

    public static String calculateCurrentDimensionValue(Integer dimension, ActivityCommonCollectionPageParticipateLimitConfDto dimensionConf) {
        return DimensionValueUtils.calculateDimensionValue(dimension, new Date(), dimensionConf);
    }

    public static boolean isCustomDimensionValid(ActivityCommonCollectionPageParticipateLimitConfDto dimensionConf) {
        if (dimensionConf == null || dimensionConf.getCustomStartTime() == null || dimensionConf.getCustomEndTime() == null) {
            return false;
        }
        Date now = new Date();
        return now.compareTo(dimensionConf.getCustomStartTime()) >= 0 && now.compareTo(dimensionConf.getCustomEndTime()) <= 0;
    }
}

