package cn.com.duiba.quanyi.center.api.enums.coupon;

import java.util.Objects;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 可用时间类型枚举
 *
 * @author xuzhigang
 * @date 2025-06-03
 */
@Getter
@AllArgsConstructor
public enum EnableTimeTypeEnum {

    UNKNOWN(0, "未知"),
    ANY_TIME_IN_VALIDITY(1, "有效期内任意时段可用"),
    AFTER_RECEIVE_X_DAYS(2, "有效期内用户领券后X天内可用"),
    REGULAR_DATE_IN_VALIDITY(3, "有效期内规则日期可用"),
    IRREGULAR_DATE_IN_VALIDITY(4, "有效期内，不规则日期可用（自动化创建的批次才有）"),

    ;

    private final Integer type;

    private final String desc;

    public static EnableTimeTypeEnum getByType(Integer type) {
        for (EnableTimeTypeEnum typeEnum : values()) {
            if (Objects.equals(typeEnum.getType(), type)) {
                return typeEnum;
            }
        }
        return null;
    }

}
