package cn.com.duiba.quanyi.center.api.dto.activity;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;

/**
 * 对应ES索引：qy_activity_store_index
 * 对应ES类型：qy_activity_store_type
 */
@Data
@ToString(callSuper = true)
public class ActivityStoreEsDto implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Integer DEFAULT_SORT = 99999;
    /**
     * 表tb_activity_prize_store id
     */
    private Long id;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 门店名称
     */
    private String storeName;

    /**
     * 门店地址
     */
    private String storeAddress;

    /**
     * 创建时间
     */
    private String gmtCreate;

    /**
     * 修改时间
     */
    private String gmtModified;

    /**
     * 门店图片
     */
    private String storeImg;

    /**
     * 是否热门：0-非热门，1-热门
     */
    private Integer hot;

    /**
     * 标签
     */
    private String tag;

    /**
     * 排序值,数值越小，排序越靠前
     */
    private Integer sort;

    /**
     * 城市
     */
    private String city;

    /**
     * 区域
     */
    private String area;

    /**
     * 商圈
     */
    private String district;

    /**
     * 行业
     */
    private String industry;

    /**
     * 品牌
     */
    private String brand;
}
