package cn.com.duiba.quanyi.center.api.remoteservice.qystatistic;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qystatistic.PurchaseOrderStatisticDto;

import java.util.List;

/**
 * 需求采购单统计数据
 * @author yangyukang
 * @date 2025-11-20 16:12
 */
@AdvancedFeignClient
public interface RemotePurchaseOrderStatisticService {
     
    /**
     * 根据主键查询
     * @param id 主键
     * @return 需求采购单统计
     */
    PurchaseOrderStatisticDto selectById(Long id);

    /**
     * 根据采购单ID查询
     * @param purchaseOrderId 采购单ID
     * @return 需求采购单统计
     */
    PurchaseOrderStatisticDto selectByPurchaseOrderId(Long purchaseOrderId);

    /**
     * 根据采购单ID列表查询
     * @param purchaseOrderIdList 采购单ID列表
     * @return 需求采购单统计列表
     */
    List<PurchaseOrderStatisticDto> selectByPurchaseOrderIdList(List<Long> purchaseOrderIdList);
}

