package cn.com.duiba.quanyi.center.api.param.api;

import lombok.Data;

import java.io.Serializable;

/**
 * @author zzy
 * @create 2025/07/02 12:42
 **/
@Data
public class WxQueryBankMultiActivityCouponDetailParam implements Serializable {
    private static final long serialVersionUID = 6965877340218266387L;
    /**
     * stock_id 必填  string(20)
     * 【批次号】批次号，是否指定批次号查询，填写available_mchid，该字段不生效。
     */
    private String stockId;

    /**
     * appid 　必填 string(128)
     * 【公众账号ID】微信为发券方商户分配的公众账号ID，接口传入的所有appid应该为公众号的appid（在mp.weixin.qq.com申请的）或APP的appid（在open.weixin.qq.com申请的）。
     * 校验规则：
     * 1、该appid需要与接口传入中的openid有对应关系；
     * 2、该appid需要与调用接口的商户号（即请求头中的商户号）有绑定关系，若未绑定，可参考该指引完成绑定（
     */
    private String appId;

    /**
     * openid 　必填 string(128)
     * 【用户标识】用户在商户appid下的唯一标识。
     * 校验规则：该openid需要与接口传入中的appid有对应关系。
     */
    private String openId;

    /**
     * coupon_id 必填  string(20) 通过调用报名活动接口获取
     * 【代金券ID】 优惠券的主键，唯一定义此资源的标识
     */
    private String couponId;

}
