package cn.com.duiba.quanyi.center.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityStoreEsDto;
import cn.com.duiba.quanyi.center.api.param.activity.ActivityStoreEsSearchParam;
import cn.com.duiba.quanyi.center.api.param.activity.ActivityStoreListQueryParam;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;

/**
 * 活动门店ES服务远程接口
 *
 * @author zzy
 * @date 2025-11-19 15:47
 */
@AdvancedFeignClient
public interface RemoteActivityStoreEsService {

    /**
     * 搜索门店
     *
     * @param param 搜索参数
     * @return 查询结果，left为总数，right为门店列表
     */
    Pair<Long, List<ActivityStoreEsDto>> search(ActivityStoreEsSearchParam param);

    /**
     * 查询所有城市
     *
     * @param param 查询参数，activityId必选
     * @return 城市列表
     */
    List<String> listCities(ActivityStoreListQueryParam param);

    /**
     * 根据城市查询区域
     *
     * @param param 查询参数，activityId和city必选
     * @return 区域列表
     */
    List<String> listAreasByCity(ActivityStoreListQueryParam param);

    /**
     * 查询所有商圈
     *
     * @param param 查询参数，activityId必选，city和area可选
     * @return 商圈列表
     */
    List<String> listDistricts(ActivityStoreListQueryParam param);

    /**
     * 查询所有行业
     *
     * @param param 查询参数，activityId必选，city、area、district可选
     * @return 行业列表
     */
    List<String> listIndustries(ActivityStoreListQueryParam param);

    /**
     * 查询所有品牌
     *
     * @param param 查询参数，activityId必选，city、area、district、industry可选
     * @return 品牌列表
     */
    List<String> listBrands(ActivityStoreListQueryParam param);
}

