package cn.com.duiba.quanyi.center.api.remoteservice.mall.version;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.mall.version.MallVersionDto;
import cn.com.duiba.quanyi.center.api.enums.BooleanEnum;
import cn.com.duiba.quanyi.center.api.param.mall.version.MallVersionSaveParam;
import cn.com.duiba.quanyi.center.api.param.mall.version.MallVersionSearchParam;
import java.util.List;

/**
 * 商城版本
 * @author kjj mybatis generator 
 * @date 2024-06-11
 */
@AdvancedFeignClient
public interface RemoteMallVersionService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 商城版本集合
     */
    List<MallVersionDto> selectPage(MallVersionSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(MallVersionSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 商城版本
     */
    MallVersionDto selectById(Long id);

    /**
     * 根据版本名称查询
     * @param versionName 版本名称
     * @return 商城版本
     */
    MallVersionDto selectByVersionName(String versionName);

    /**
     * 保存商城版本
     *
     * @param param 商城版本参数
     * @return 主键
     */
    Long save(MallVersionSaveParam param);

    /**
     * 更新
     * @param dto 商城版本
     * @return 影响行数
     */
    int update(MallVersionDto dto);

    /**
     * 更改状态
     * @param id 主键
     * @param status 状态
     * @see cn.com.duiba.quanyi.center.api.enums.mall.MallStatusEnum
     * @return 是否成功
     */
    boolean changeStatus(Long id, Integer status);

    /**
     * 更改是否展示地址tab
     * @param id 主键
     * @param showAddressTab 状态
     * @see BooleanEnum
     * @return 是否成功
     */
    boolean changeShowAddressTab(Long id, Integer showAddressTab);

    /**
     * 根据首页页面id查询
     * @param homePageId 主键
     */
    MallVersionDto selectByHomePageId(Long homePageId);

    /**
     * 根据id批量查询
     * @param ids 主键ID列表
     * @return 商城版本列表
     */
    List<MallVersionDto> selectByIds(List<Long> ids);
}