package cn.com.duiba.quanyi.center.api.dto.activity.common.result.collection;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * 集合页参与限制结果DTO（分组维度统计）
 * 支持多分组、多维度的统计逻辑
 * 
 * 业务场景：
 * - 一个集合页可以有多个分组，每个分组独立统计
 * - 每个分组可以设置不同的维度（永久、日、周、月、季度、自定义）
 * - 每个分组维度下独立记录用户的参与统计
 * 
 * @author lizhi
 * @author yangyukang
 * @date 2025/7/4 11:48
 */
@Data
public class ActivityCommonParticipateLimitResultDto implements Serializable {

    private static final long serialVersionUID = 6312383717459009017L;

    /**
     * 是否启用
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer enable;

    /**
     * 分组ID（0表示无分组）
     * 用于唯一标识一个分组配置
     */
    private Long groupId;

    /**
     * 分组内的活动ID列表
     */
    private List<Long> activityIdList;

    /**
     * 参与活动限制个数
     * 表示在该分组内，用户最多可以参与多少个活动
     */
    private Integer participateNum;

    /**
     * 剩余可参与活动数量
     * 计算公式：participateNum - 已参与活动数
     */
    private Long surplusParticipateNum;

    /**
     * 维度类型
     * @see cn.com.duiba.quanyi.center.api.enums.activity.MultiSelectNDimensionEnum
     * 0-永久，1-日，2-自然周，3-自然月，4-自然季度，5-自定义
     */
    private Integer dimension;

    /**
     * 周期标识（与dimension配合使用）
     * 格式说明：
     * - 永久（不限制）：0
     * - 日维度：20250120 (yyyyMMdd)
     * - 自然周：2025W03 (yyyyWww)
     * - 自然月：202512 (yyyyMM)
     * - 自然季度：2025Q4 (yyyyQq)
     * - 自定义：custom_20250101-20250131（在有效期内）或0（不在有效期内）
     */
    private String dimensionPeriod;

    /**
     * 用户领取统计数据表ID
     * 对应user_take_stat表的主键
     */
    private Long userTakeStatId;

    /**
     * 该分组维度下已领取次数
     * 用于校验领取记录并发写入
     */
    private Long takeCount;

    /**
     * 最后一次领取记录ID
     * 用于校验领取记录并发写入
     */
    private Long lastRecordId;

    /**
     * 该分组维度下已参与的活动ID，下划线分割
     * 例如："1001_1002_1003"
     */
    private String takeActivityIds;

    /**
     * 该分组维度下已参与的活动ID列表（已解析）
     */
    private List<Long> participateActivityIds;
}
