package cn.com.duiba.quanyi.center.api.remoteservice.task;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.task.ScheduledTaskDto;
import cn.com.duiba.quanyi.center.api.param.task.ScheduledTaskSearchParam;
import java.util.List;

/**
 * 定时任务表
 * @author kjj mybatis generator
 * @date 2025-06-11
 */
@AdvancedFeignClient
public interface RemoteScheduledTaskService {

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 定时任务集合
     */
    List<ScheduledTaskDto> selectPage(ScheduledTaskSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ScheduledTaskSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 定时任务
     */
    ScheduledTaskDto selectById(Long id);

    /**
     * 新增
     * @param dto 定时任务
     * @return 执行结果
     */
    int insert(ScheduledTaskDto dto);

    /**
     * 更新
     * @param dto 定时任务
     * @return 影响行数
     */
    int update(ScheduledTaskDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 手动执行定时任务
     * @param ids 定时任务主键ID集合
     *   @return 执行结果
     */
    int execute(List<Long> ids);
}
