package cn.com.duiba.quanyi.center.api.remoteservice.activity.verify;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.common.cache.ActivityCommonCustomSignUpVerifyDto;

import java.util.concurrent.TimeUnit;

/**
 * @author lizhi
 * @date 2025/5/15 15:34
 */
@AdvancedFeignClient
public interface RemoteActivityCommonCustomSignUpVerifyService {

    /**
     * 查询用户报名定制验证结果
     * @param userId 用户ID
     * @param activityId 活动ID
     * @return 验证结果
     */
    ActivityCommonCustomSignUpVerifyDto get(Long userId, Long activityId);

    /**
     * 设置用户报名定制验证结果
     * @param userId 用户ID
     * @param activityId 活动ID
     * @param dto 结果
     * @param timeout 缓存时间
     * @param unit 时间单位
     * @return 是否成功
     */
    boolean set(Long userId, Long activityId, ActivityCommonCustomSignUpVerifyDto dto, int timeout, TimeUnit unit);
}
