package cn.com.duiba.quanyi.center.api.dto.activity.common.result;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2025/6/3 18:27
 */
@Data
public class ActivityCommonCanParticipateDto implements Serializable {

    private static final long serialVersionUID = 7064195152820641748L;

    /**
     * 是否可参与
     * 集合页纬度-用户身份校验、风控等校验后不可参与
     * 活动纬度-用户身份校验、黑名单、白名单、风控等校验后不可参与活动
     * 奖品纬度-白名单、达标等校验后不可参与奖品
     */
    private Boolean canParticipate;

    /**
     * 不可参与错误码，canParticipate 为false时有值
     */
    private String participateErrCode;

    /**
     * 是否可参与(忽略白名单限制)
     * 集合页纬度-用户身份校验、风控等校验后不可参与
     * 活动纬度-用户身份校验、黑名单、风控等校验后不可参与活动
     * 奖品纬度-达标等校验后不可参与奖品
     */
    private Boolean canParticipateIgnoringWhitelist;

    /**
     * 不可参与(忽略白名单限制)错误码，canParticipateIgnoringWhitelist 为false时有值
     */
    private String participateIgnoringWhitelistErrCode;
}
