package cn.com.duiba.quanyi.center.api.utils.activity;

import cn.com.duiba.quanyi.center.api.dto.activity.CouponExpireTypeDto;
import cn.com.duiba.quanyi.center.api.enums.activity.CouponExpireTypeEnum;
import cn.com.duiba.wolf.utils.DateUtils;

import java.util.Date;
import java.util.Objects;

/**
 * @author lizhi
 * @date 2025/6/10 14:57
 */
public class ActivityShortUrlExpireTimeUtils {

    private ActivityShortUrlExpireTimeUtils() {}

    /**
     * 获取短链有效时间
     * @param endTime 批次结束时间
     * @param couponExpireTypeDto 短链有效时间配置
     * @return 短链有效时间
     */
    public static Date getExpireTime(Date endTime, CouponExpireTypeDto couponExpireTypeDto) {
        if(Objects.isNull(couponExpireTypeDto)) {
            return null;
        }
        if(Objects.equals(couponExpireTypeDto.getCouponExpireType(), CouponExpireTypeEnum.SPECIFY_DATE.getType())) {
            return couponExpireTypeDto.getExpireTime();
        } else if(Objects.equals(couponExpireTypeDto.getCouponExpireType(), CouponExpireTypeEnum.REVERSE_DAYS.getType())) {
            return DateUtils.daysAddOrSub(QyDateTimeUtils.getDayEndTime(endTime), -couponExpireTypeDto.getReverseDays());
        } else if(Objects.equals(couponExpireTypeDto.getCouponExpireType(), CouponExpireTypeEnum.ORDER_DAY.getType())) {
            //从当天算第一天，所以-1
            return DateUtils.daysAddOrSub(QyDateTimeUtils.getDayEndTime(new Date()), couponExpireTypeDto.getOrderDays() - 1);
        } else if(Objects.equals(couponExpireTypeDto.getCouponExpireType(), CouponExpireTypeEnum.NOW_MONTH_END.getType())) {
            return QyDateTimeUtils.getCurrentMonthEndTime(new Date());
        } else if(Objects.equals(couponExpireTypeDto.getCouponExpireType(), CouponExpireTypeEnum.NOW_WEEK_END.getType())) {
            return QyDateTimeUtils.getSundayOfThisWeek();
        }
        return null;
    }
}
