package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 中行绑定类型枚举
 * @author yangyukang
 * @date 2025/01/21
 */
@Getter
@AllArgsConstructor
public enum ActivityBoBindingTypeEnum {
    
    API_CALL(1, "API主动调用"),
    WECHAT(2, "微信"),
    ALIPAY(3, "支付宝"),
    MOBILE(4, "手机号"),
    BEIJING_BOC_APP(5, "北京中行app"),
    BEIJING_BOC_WECHAT(6, "北京中行微信端"),
    BOC(7, "中行客户")

    
    ;
    
    private Integer type;
    private String desc;
    
    /**
     * 根据类型获取枚举
     * @param type 类型
     * @return 枚举值
     */
    public static ActivityBoBindingTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        for (ActivityBoBindingTypeEnum bindingType : values()) {
            if (bindingType.getType().equals(type)) {
                return bindingType;
            }
        }
        return null;
    }
    
    /**
     * 判断类型是否有效
     * @param type 类型
     * @return 是否有效
     */
    public static boolean isValidType(Integer type) {
        return getByType(type) != null;
    }
}

