package cn.com.duiba.quanyi.center.api.dto.activity.common.cache;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 支付订单领取凭证
 * @author mybatis generator
 * @date 2025-04-15
 */
@Data
public class PayOrderTakeVoucherCacheDto implements Serializable {

    private static final long serialVersionUID = 17446989970488335L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 支付单号
     */
    private String bizOrderNo;

    /**
     * 领取类型：1-可领一次，2-可领多次
     * @see cn.com.duiba.quanyi.center.api.enums.pay.PayOrderTakeVoucherTakeTypeEnum
     */
    private Integer takeType;

    /**
     * 奖品ID
     */
    private Long prizeId;

    /**
     * 已领取次数
     */
    private Long takeCount;

    /**
     * 领取记录ID，英文逗号分隔
     */
    private String recordIds;

    /**
     * 失效时间
     */
    private Date expireDate;

    /**
     * 失效后是否需要退款
     */
    private Integer needRefund;
}
