package cn.com.duiba.quanyi.center.api.param.mall.version;

import cn.com.duiba.quanyi.center.api.enums.mall.MallDeliveryTypeEnum;
import cn.com.duiba.quanyi.center.api.enums.mall.MallVersionTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author lizhi
 * @date 2024/6/11 17:04
 */
@Data
public class MallVersionSaveParam implements Serializable {

    private static final long serialVersionUID = 68670052440095003L;

    /**
     * 版本名称
     */
    private String versionName;

    /**
     * 负责人Id
     */
    private Long ownerId;

    /**
     * 负责人姓名
     */
    private String ownerName;

    /**
     * 创建人ssoId
     */
    private Long createOperatorId;

    /**
     * 创建人姓名
     */
    private String createOperatorName;

    /**
     * 需求ID
     */
    private Long demandId;

    /**
     * 投放形式：0-小程序，1-H5
     *
     * @see MallDeliveryTypeEnum#getCode()
     */
    private Integer deliveryType;

    /**
     * 备注
     */
    private String remark;

    /**
     * 版本类型
     * 0-保司 1-银行
     *
     * @see MallVersionTypeEnum#getCode()
     */
    private Integer versionType;

    /**
     * 是否托管积分
     * 1-是 0-否
     */
    private Integer trusteeship;

    /**
     * 托管关联公司
     */
    private List<Long> companyIds;

    /**
     * 支付渠道类型
     *
     * @see cn.com.duiba.quanyi.center.api.enums.pay.PayChannelTypeEnum#getChannelType()
     */
    private List<String> payChannelTypes;
}
