package cn.com.duiba.quanyi.center.api.param.mall.version;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;

/**
 * 商城版本
 * @author mybatis generator 
 * @date 2024-06-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class MallVersionSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17180959454427564L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 版本名称
     */
    private String versionName;

    /**
     * 版本状态：0-未上架，1-已上架
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer versionStatus;

    /**
     * 负责人Id
     */
    private Long ownerId;

    /**
     * 创建人ssoId
     */
    private Long createOperatorId;

    /**
     * 版本备注
     */
    private String remark;
}