package cn.com.duiba.quanyi.center.api.dto.activity.group;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 活动分组DTO
 * 
 * @author yangyukang
 * @date 2025-12-15 23:30
 */
@Data
public class ActivityGroupDto implements Serializable {
    
    private static final long serialVersionUID = 3847562190847562190L;
    
    /**
     * 分组ID
     */
    private Long id;
    
    /**
     * 集合页ID
     */
    private Long collectionPageId;
    
    /**
     * 分组内的活动ID列表（已解析）
     */
    private List<Long> activityIdList;
    
    /**
     * 参与活动限制个数
     */
    private Integer participateNum;
    
    /**
     * 维度类型
     */
    private Integer dimension;
    
    /**
     * 自定义开始时间
     */
    private Date customStartTime;
    
    /**
     * 自定义结束时间
     */
    private Date customEndTime;
}

