package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 活动奖品定时任务执行转态
 * 0:未执行
 * 1:执行中
 * 2:执行成功
 * 3:执行失败
 * @author lfh
 */
@Getter
@AllArgsConstructor
public enum ActivityPrizeScheduledExecutionStatusEnum {

    UNEXECUTED(0, "未执行"),
    EXECUTING(1, "执行中"),
    SUCCESS(2, "执行成功"),
    FAIL(3, "执行失败")
    ;


    private final Integer type;

    private final String desc;


    public static ActivityPrizeScheduledExecutionStatusEnum getByType(Integer type) {
        for (ActivityPrizeScheduledExecutionStatusEnum value : values()) {
            if (value.getType().equals(type)) {
                return value;
            }
        }
        return null;
    }
}
