package cn.com.duiba.quanyi.center.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityPrizeStoreDto;

import java.util.List;

/**
 * 奖项门店表
 *
 * @author kjj mybatis generator
 * @date 2024-03-21
 */
@AdvancedFeignClient
public interface RemoteActivityPrizeStoreService {

    /**
     * 新增
     *
     * @param dto 奖项门店
     * @return 执行结果
     */
    Long insert(ActivityPrizeStoreDto dto);

    /**
     * 批量新增
     *
     * @param list 奖项门店
     * @return 执行结果
     */
    int batchInsert(List<ActivityPrizeStoreDto> list);

    /**
     * 更新
     *
     * @param dto 奖项门店
     * @return 影响行数
     */
    int update(ActivityPrizeStoreDto dto);

    /**
     * 软删
     *
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 批量删除
     *
     * @param activityId    活动主键
     * @param storeNameList 门店名称列表
     * @return 影响行数
     */
    int batchDelete(Long activityId, List<String> storeNameList);
}
