package cn.com.duiba.quanyi.center.api.dto.api;

import cn.com.duiba.quanyi.center.api.enums.api.ApiMainOrderStatusEnum;
import cn.com.duiba.quanyi.center.api.enums.api.ApiMultiChoiceOneOrderStatusEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;

/**
 * API供给
 * @author lizhi
 * @date 2023/12/4 20:31
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class ApiMultiChoiceOneOrderResult extends ApiBaseResult {

    private static final long serialVersionUID = 4372430151952159865L;

    /**
     * API对接ID
     */
    private Long apiJointId;

    /**
     * 商品类型
     *
     * @see cn.com.duiba.quanyi.center.api.enums.api.ApiSpecTypeEnum
     */
    private Integer specType;

    /**
     * 商品ID
     */
    private Long specId;

    /**
     * 主订单号
     */
    private String orderNo;

    /**
     * 开发者自有参数，兑吧透传
     */
    private String remark;

    /**
     * 券包主订单状态：
     * ● 1：处理中
     * ● 2：全部成功
     * ● 3：全部失败
     * @see ApiMultiChoiceOneOrderStatusEnum
     */
    private Integer orderStatus;

    /**
     * 客户单号
     */
    private String thirdOrderId;

    /**
     * 下单结果、状态变更通知url
     */
    private String notifyUrl;

    /**
     * 回调通知mq topic
     */
    private String notifyMqTopic;

    /**
     * 同步结果mq topic
     */
    private String syncMqTopic;

    /**
     * 链接券-短链
     */
    private String shortUrl;

    /**
     * 失效时间, 时间戳
     */
    private Long expireTime;

    /**
     * 最后更新时间, 时间戳
     */
    private Long lastTime;

    /**
     * 发放时间，时间戳
     */
    private Long grantTime;

    /**
     * apiOrderResult
     */
    private ApiOrderResult apiOrderResult;
}
