package cn.com.duiba.quanyi.center.api.dto.promotion;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author zhuenhui
 * @date 2022/03/21 12:41
 * @description 外链推广-落地页配置Dto
 */
@Data
public class LinkPromotionConfDto implements Serializable {

    private static final long serialVersionUID = -6491791195425626434L;

    /**
     * 主键Id
     */
    private Long id;

    /**
     * mpId
     */
    private String mpId;

    /**
     * 小程序id
     */
    private String appId;

    /**
     * 小程序页面
     */
    private String pageUrl;

    /**
     * h5链接
     */
    private String url;

    /**
     * 备注
     */
    private String remark;

    /**
     * schemeUrl
     */
    private String schemeUrl;

    /**
     * 是否自动续期：0-不续期，1-续期
     */
    private Integer autoRenew;

    /**
     * scheme_url有效期
     */
    private Date schemeUrlExpireTime;

    /**
     * 创建人sso id
     */
    private Long createOperatorId;

    /**
     * 创建人
     */
    private String createOperatorName;


    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

}

