/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.goods.service.api.enums.supplier;

import cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum SupplierApiCodeEnum {
    WX_FAVOR_ZY("wx_favor_zy", "\u5fae\u4fe1\u7acb\u51cf\u91d1", SpuTypeEnum.WX_COUPON, true),
    ALIPAY_COUPON_CARD("alipay_coupon_card", "\u652f\u4ed8\u5b9d\u7acb\u51cf\u91d1", SpuTypeEnum.ALIPAY_COUPON, true),
    I_QI_YI_ZC("i_qi_yi_zc", "\u7231\u5947\u827a\u76f4\u5145", SpuTypeEnum.I_QI_YI_ZC, true),
    ALIPAY_COUNT_COINS("alipay_count_coins", "\u652f\u4ed8\u5b9d\u6570\u5e01\u7ea2\u5305", SpuTypeEnum.ALIPAY_COUNT_COINS, true),
    CCB_PAY_COUNT_COINS("ccb_count_coins", "\u5efa\u884c\u6570\u5e01\u7ea2\u5305", SpuTypeEnum.CCB_COUNT_COINS, true),
    CARD_SECRET("card_secret", "\u5361\u5bc6", SpuTypeEnum.KA_MI, true);

    private final String code;
    private final String desc;
    private final SpuTypeEnum spuType;
    private final boolean canSelect;
    private static final Map<String, SupplierApiCodeEnum> ENUM_MAP;

    public static SupplierApiCodeEnum getByCode(String code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public SpuTypeEnum getSpuType() {
        return this.spuType;
    }

    public boolean isCanSelect() {
        return this.canSelect;
    }

    private SupplierApiCodeEnum(String code, String desc, SpuTypeEnum spuType, boolean canSelect) {
        this.code = code;
        this.desc = desc;
        this.spuType = spuType;
        this.canSelect = canSelect;
    }

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(SupplierApiCodeEnum.values()).collect(Collectors.toMap(SupplierApiCodeEnum::getCode, Function.identity(), (v1, v2) -> v2)));
    }
}

