package cn.com.duiba.quanyi.goods.service.api.dto.cardsecret;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 卡密批次表
 *
 * @author kjj mybatis generator
 * @date 2023-11-21
 */
@Data
public class CardSecretBatchDto implements Serializable {

    private static final long serialVersionUID = 17005478015811401L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 卡密商品ID
     */
    private Long spuId;

    /**
     * 卡密类型，1-券码，2-链接券,3-用户名-密码
     */
    private Integer cardSecretType;

    /**
     * 生效时间
     */
    private Date effectiveTime;

    /**
     * 失效时间
     */
    private Date expirationTime;

    /**
     * 需求主键, tb_demand.id
     */
    private Long demandId;

    /**
     * 采购商品主键, tb_purchase_goods.id
     */
    private Long demandGoodsId;

    /**
     * 商品规格ID
     */
    private Long skuId;

    /**
     * 状态 0-启用 1-未启用
     */
    private Integer status;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Integer logicDelete;

    /**
     * 创建人ID
     */
    private Long creatorId;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}