package cn.com.duiba.quanyi.goods.service.api.dto.order;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 订单表
 *
 * @author kjj mybatis generator
 * @date 2023-11-28
 */
@Data
public class OrderDto implements Serializable {

    private static final long serialVersionUID = 17011668851602088L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 唯一订单号
     */
    private String orderNo;

    /**
     * SPU id
     */
    private Long spuId;

    /**
     * SKU id
     */
    private Long skuId;

    /**
     * 供应商id
     */
    private Long supplierId;

    /**
     * 客户id
     */
    private Long customerId;

    /**
     * 客户订单号
     */
    private String customerOrderNo;

    /**
     * 商品数量
     */
    private Integer quantity;

    /**
     * 订单状态
     */
    private Integer orderStatus;

    /**
     * 商品类型
     */
    private Integer spuType;

    /**
     * 订单价格，单位分
     */
    private Integer orderPrice;

    /**
     * 备注，买家留言
     */
    private String remark;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}