package cn.com.duiba.quanyi.goods.service.api.param.cardsecret;

import cn.com.duiba.quanyi.goods.service.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class CardSecretQueryParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = 3491253223016071364L;

    /**
     * 卡密商品ID
     */
    private Long spuId;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 生效时间 - 开始
     */
    private Date effectiveTimeStart;

    /**
     * 生效时间 - 结束
     */
    private Date effectiveTimeEnd;

    /**
     * 创建时间-开始
     */
    private Date createTimeStart;

    /**
     * 创建时间-结束
     */
    private Date createTimeEnd;

    /**
     * 创建人操作Id
     */
    private Long createOperatorId;

    /**
     * 当前需求商品主键, tb_demand_goods.id,b
     */
    private List<Long> demandGoodsIds;

    /**
     * 状态 0-启用 1-未启用
     */
    private Integer status;

}
