package cn.com.duiba.quanyi.goods.service.api.remoteservice.cardsecret;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.cardsecret.CardSecretBatchDto;
import cn.com.duiba.quanyi.goods.service.api.param.cardsecret.CardSecretBindDemandGoodsParam;
import cn.com.duiba.quanyi.goods.service.api.param.cardsecret.CardSecretQueryParam;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * CardSecretRemoteService
 */
@AdvancedFeignClient
public interface RemoteCardSecretBatchService {

    /**
     * 更新
     *
     * @param dto 参数dto
     * @return 影响行数
     */
    Long update(CardSecretBatchDto dto);

    /**
     * 保存
     *
     * @param dto 参数dto
     * @return 影响行数
     */
    Long insert(CardSecretBatchDto dto);

    /**
     * 根据主键ID查询
     *
     * @param id 主键ID
     * @return CardSecretDto
     */
    CardSecretBatchDto selectById(Long id);

    /**
     * 删除
     *
     * @param id 主键ID
     * @return 影响行数
     */
    int delete(Long id);

    /**
     * 统计行数
     *
     * @param queryParam 查询参数
     * @return 行数
     */
    Integer count(CardSecretQueryParam queryParam);

    /**
     * 分页查询
     *
     * @param queryParam 查询参数
     * @return A List Of CardSecretDto
     */
    List<CardSecretBatchDto> selectPage(CardSecretQueryParam queryParam);

    /**
     * 根据ids查询
     *
     * @param ids ids
     * @return A Map Of Id Mapping CardSecretDto
     */
    Map<Long, CardSecretBatchDto> selectByIdList(Set<Long> ids);

    /**
     * 根据需求商品ID查询
     *
     * @param demandGoodId 需求商品ID
     * @return A List Of CardSecretDto
     */
    List<CardSecretBatchDto> findByDemandGoodsId(Long demandGoodId);

    /**
     * 批量绑定需求商品
     *
     * @param goodsParamList 需要绑定的集合
     * @return 影响行数
     */
    int batchBindDemandGoods(List<CardSecretBindDemandGoodsParam> goodsParamList);

    /**
     * 批量取消绑定需求商品
     *
     * @param unBindList   需要取消绑定的ID集合
     * @param demandGoodId 需求商品ID
     * @return 影响行数
     */
    int batchUnbindDemandGoods(List<Long> unBindList, Long demandGoodId);

    /**
     * 根据需求ID和SKU查询
     *
     * @param demandId 需求ID
     * @param skuId    SKU ID
     * @return A List Of CardSecretDto
     */
    List<CardSecretBatchDto> selectByDemandSkuId(Long demandId, Long skuId);

}
