package cn.com.duiba.quanyi.goods.service.api.remoteservice.cardsecret;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.cardsecret.CardSecretCouponDto;
import cn.com.duiba.quanyi.goods.service.api.param.cardsecret.CardSecretCouponQueryParam;

import java.util.List;
import java.util.Set;

/**
 * CardSecretCouponRemoteService
 */
@AdvancedFeignClient
public interface RemoteCardSecretCouponService {

    /**
     * 批量保存和返回之前存在
     *
     * @param bizType           业务类型 3 - 兑换码 4 - 链接劵 5 - 账号和密码
     * @param cardSecretBatchId 卡密批次ID
     * @param dtoList           需要保存的dto
     * @return 劵码
     */
    Set<String> batchInsertAndGetExist(Integer bizType, Long cardSecretBatchId, List<CardSecretCouponDto> dtoList);

    /**
     * 统计行数
     *
     * @param queryParam 查询参数
     * @return 行数
     */
    Integer count(CardSecretCouponQueryParam queryParam);

    /**
     * 分页查询
     *
     * @param queryParam 查询参数
     * @return A List Of CardSecretCouponDto
     */
    List<CardSecretCouponDto> selectPage(CardSecretCouponQueryParam queryParam);

    /**
     * 根据卡密批次IDh和劵码状态查询
     *
     * @param cardSecretBatchId 卡密批次ID
     * @param codeStatus        劵码状态
     * @return A List Of CardSecretCouponDto
     */
    List<CardSecretCouponDto> selectByCardSecretBatchIdAndStatus(Long cardSecretBatchId, Integer codeStatus);

    /**
     * 根据任务ID查询
     *
     * @param taskId 任务ID
     * @return A List Of CardSecretCouponDto
     */
    List<CardSecretCouponDto> selectByTaskId(Long taskId);

}
