package cn.com.duiba.quanyi.goods.service.api.remoteservice.cardsecret;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.cardsecret.CardSecretStockDto;

import java.util.List;
import java.util.Set;

/**
 * RemoteCardSecretStockService
 */
@AdvancedFeignClient
public interface RemoteCardSecretStockService {

    /**
     * 根据卡密批次ID去查询
     *
     * @param cardSecretBatchIds 卡密批次IDS
     * @return A List CardSecretStockDto
     */
    List<CardSecretStockDto> selectByCardSecretBatchIds(List<Long> cardSecretBatchIds);

    /**
     * 扣减一个库存
     *
     * @param cardSecretBatchId 卡密批次ID
     * @return 执行结果
     */
    int subOneStock(Long cardSecretBatchId);

    /**
     * 查询有库存的立减金id
     *
     * @param batchIds 卡密批次ID集合
     * @return 卡密批次ID集合
     */
    Set<Long> selectAvailableInventoryByCardSecretBatchIds(Set<Long> batchIds);
}
