package cn.com.duiba.quanyi.goods.service.api.remoteservice.cardsecret;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.cardsecret.OrderCardSecretRecordDto;
import cn.com.duiba.quanyi.goods.service.api.param.cardsecret.OrderCardSecretRecordSearchParam;
import java.util.List;

/**
 * 卡密订单记录表
 * @author kjj mybatis generator 
 * @date 2023-12-10
 */
@AdvancedFeignClient
public interface RemoteOrderCardSecretRecordService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 卡密订单记录集合
     */
    List<OrderCardSecretRecordDto> selectPage(OrderCardSecretRecordSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(OrderCardSecretRecordSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 卡密订单记录
     */
    OrderCardSecretRecordDto selectById(Long id);

    /**
     * 新增
     * @param dto 卡密订单记录
     * @return 影响行数
     */
    int insert(OrderCardSecretRecordDto dto);

    /**
     * 更新
     * @param dto 卡密订单记录
     * @return 影响行数
     */
    int update(OrderCardSecretRecordDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 影响行数
     */
    int delete(Long id);
}