package cn.com.duiba.quanyi.goods.service.api.dto.order.supplier;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 供应商订单-支付宝立减金扩展字段
 * @author kjj mybatis generator 
 * @date 2023-11-28
 */
@Data
public class SupplierOrderAlipayCouponDto implements Serializable {
     
    private static final long serialVersionUID = 17011697747348561L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 订单号
     */
    private String orderNo;

    /**
     * 支付宝活动id
     */
    private String actId;

    /**
     * 支付宝分配给开发者的应用ID
     */
    private String appId;

    /**
     * 券平台唯一id
     */
    private String voucherId;

    /**
     * 接收渠道红包的，脱敏后的支付宝登录号
     */
    private String accountNo;

    /**
     * 活动流水唯一记录
     */
    private String activityOrderId;

    /**
     * 支付宝用户ID
     */
    private String userId;

    /**
     * 支付宝用户登录ID
     */
    private String loginId;

    /**
     * 支付宝用户手机号
     */
    private String phoneId;

    /**
     * reduce:满立减,random:随机立减
     */
    private String discountType;

    /**
     * 优惠门槛金额
     */
    private Long discountThresholdAmt;

    /**
     * 满减或随机金额
     */
    private Long discountValue;

    /**
     * 发放金额
     */
    private Long sendAmount;

    /**
     * 支付宝响应结果json字符串
     */
    private String body;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}