package cn.com.duiba.quanyi.goods.service.api.dto.supplier;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 供应商商品类型关联表
 * @author kjj mybatis generator 
 * @date 2023-11-28
 */
@Data
public class SupplierSpuTypeRefDto implements Serializable {
     
    private static final long serialVersionUID = 17011627957257280L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 供应商ID
     */
    private Long supplierId;

    /**
     * 类型值，见枚举值 SpuTypeEnum
     */
    private Integer spuType;

    /**
     * api编码，见枚举值 SupplierApiCodeEnum
     */
    private String supplierApiCode;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Integer logicDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}