package cn.com.duiba.quanyi.goods.service.api.remoteservice.order.supplier;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.order.supplier.SupplierOrderDto;
import cn.com.duiba.quanyi.goods.service.api.param.order.supplier.SupplierOrderSearchParam;
import java.util.List;

/**
 * 供应商订单表
 * @author kjj mybatis generator 
 * @date 2023-11-28
 */
@AdvancedFeignClient
public interface RemoteSupplierOrderService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 供应商订单集合
     */
    List<SupplierOrderDto> selectPage(SupplierOrderSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(SupplierOrderSearchParam param);
}