package cn.com.duiba.quanyi.goods.service.api.remoteservice.supplier;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.supplier.SupplierSpuTypeRefDto;

import java.util.List;

/**
 * 供应商商品类型关联表
 * @author kjj mybatis generator 
 * @date 2023-11-28
 */
@AdvancedFeignClient
public interface RemoteSupplierSpuTypeRefService {

    /**
     * 根据商品类型查询响应的供应商
     * @param spuType 商品类型
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     * @return 供应商主键ID
     */
    List<Long> selectSupplierIdsBySpuType(Integer spuType);

    /**
     * 新增
     * @param dto 供应商商品类型关联
     * @return 影响行数
     */
    int insert(SupplierSpuTypeRefDto dto);

    /**
     * 更新
     * @param dto 供应商商品类型关联
     * @return 影响行数
     */
    int update(SupplierSpuTypeRefDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 影响行数
     */
    int delete(Long id);
}