package cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.virtual.iqiyi;

import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.BaseOrderCreateExtReq;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @author lizhi
 * @date 2023/8/9 10:14
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class IQiYiZcOrderCreateReq extends BaseOrderCreateExtReq {

    private static final long serialVersionUID = 7022897259613176233L;

    /**
     * 用户手机号, 3选1
     * 手机号，未注册的爱奇艺会自动注册，并下发短信通知用户账号信息
     */
    private String mobile;

    /**
     * 加密的手机号, 3选1
     * 加密格式的手机号（其他同上），采用RSA加密，加密方法见RSA加密，密钥由爱奇艺提供
     */
    private String encryptedMobile;

    /**
     * 合作方用户id, 3选1
     * 对于无法传手机号的合作方，在与爱奇艺passport完成对接后，可传此字段。如果同时传入mobile/ encryptedMobile字段，优先取此字段。
     */
    private String partnerUserId;
}
