package cn.com.duiba.quanyi.goods.service.api.enums.goods;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 商品类型
 *
 * @author lizhi
 * @date 2023/11/20 11:46
 */
@Getter
@AllArgsConstructor
public enum SpuTypeEnum {

    OBJECT(1, "实物"),
    WX_COUPON(2, "微信立减金"),
    ALIPAY_COUPON(3, "支付宝立减金"),
    I_QI_YI_ZC(4, "爱奇艺直充"),
    ALIPAY_COUNT_COINS(5, "支付宝数币红包"),
    CCB_COUNT_COINS(6, "建行数币红包"),
    KA_MI(7, "卡密"),
    MEI_TUAN_STORE(8, "美团到店"),
    YOU_KU(9, "优酷"),
    TE_LAI_DIAN_COUPON(10, "特来电卡劵直充"),
    TUAN_YOU(11, "团油"),
    WX_TRANSFER(12, "微信到零钱"),
    BA_WANG_CHA_JI(16, "霸王茶姬"),
    CLOUD_360_VIP(13, "360安全云盘会员"),
    WU_PIAO_HUA_FEI(14, "无票话费"),
    MI_GU_VIDEO_VIP(17, "咪咕视频会员"),
    QQ_VIP(18, "QQ会员"),
    TEN_XUN_QQ_MUSIC_VIP(19, "腾讯QQ音乐会员"),
    DIDI_CAR_COUPON(20, "滴滴快车代金券"),
    RUI_XING_COFFE_ZC(21, "瑞幸咖啡直充"),
    QB(22, "Q币"),
    CLOUD_BAI_DU_VIP(24, "百度云盘会员"),
    WANG_YI_YUN_VIP(25, "网易云会员"),
    TEN_XUN_VIDEO_VIP(26, "腾讯视频会员"),
    NAI_XUE_ZC(23, "奈雪直充"),
    BI_LI_BI_LI_VIP(27, "哔哩哔哩会员"),
    ;

    private final Integer type;

    private final String desc;

    private static final Map<Integer, SpuTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(SpuTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据枚举值获取枚举
     *
     * @param type 枚举值
     * @return 枚举
     */
    public static SpuTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
