package cn.com.duiba.quanyi.goods.service.api.dto.order.supplier;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 供应商订单-微信到零钱扩展字段
 * @author kjj mybatis generator 
 * @date 2024-01-22
 */
@Data
public class SupplierOrderWxTransferDto implements Serializable {
     
    private static final long serialVersionUID = 17059055519901592L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 订单号
     */
    private String orderNo;

    /**
     * 客户订单号
     */
    private String customerOrderNo;

    /**
     * 公众账号ID
     */
    private String appId;

    /**
     * openId
     */
    private String openId;

    /**
     * 转账金额，单位：分
     */
    private Long amount;

    /**
     * 微信的转账备注
     */
    private String remark;

    /**
     * 用户真实姓名
     */
    private String realName;

    /**
     * 最后一次状态变更的时间
     */
    private Date updateTime;

    /**
     * 子订单号
     */
    private String subOrderNo;

    /**
     * 供应商api标识码
     */
    private String supplierApiCode;

    /**
     * SPU id
     */
    private Long spuId;

    /**
     * SKU id
     */
    private Long skuId;

    /**
     * 发放时间
     */
    private Date grantTime;

    /**
     * 发放虚拟商品所需信息
     */
    private String accountInfo;

    /**
     * 虚拟商品发放状态
     * @see cn.com.duiba.quanyi.goods.service.api.enums.order.supplier.SupplierOrderStatusEnum
     */
    private Integer grantStatus;

    /**
     * 供应商返回的唯一流水号
     */
    private String supplierBizNo;

    /**
     * 供应商错误信息
     */
    private String errMsg;

    /**
     * 发放结果json
     */
    private String grantResult;
}