/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.goods.service.api.enums.coupon;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum StockTypeEnum {
    WX(1, "\u5fae\u4fe1\u7acb\u51cf\u91d1"),
    ALIPAY(2, "\u652f\u4ed8\u5b9d\u7acb\u51cf");

    private final Integer type;
    private final String desc;
    private static final Map<Integer, StockTypeEnum> ENUM_MAP;

    public static StockTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    private StockTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(StockTypeEnum.values()).collect(Collectors.toMap(StockTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));
    }
}

