package cn.com.duiba.quanyi.goods.service.api.remoteservice.order.express;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.order.express.OrderExpressDetailDto;
import cn.com.duiba.quanyi.goods.service.api.dto.order.express.OrderExpressDto;

import java.util.List;

/**
 * 订单物流信息表RPC
 *
 * @author wangguanhua
 */
@AdvancedFeignClient
public interface RemoteOrderExpressService {

    /**
     * update express info
     *
     * @param expressNo   express no
     * @param expressInfo express info
     * @return int
     */
    int updateExpressInfo(String expressNo, String expressInfo);


    /**
     * select by express no
     *
     * @param expressNo express no
     * @return {@link List}<{@link OrderExpressDto}>
     */
    List<OrderExpressDto> selectByExpressNo(String expressNo);

    /**
     * select by express no and order no
     *
     * @param expressNo express no
     * @param orderNo   order no（非必填）
     * @return {@link OrderExpressDetailDto}
     */
    OrderExpressDetailDto selectByExpressNoAndOrderNo(String expressNo, String orderNo);

}
