package cn.com.duiba.quanyi.goods.service.api.remoteservice.supplier;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.supplier.SupplierOrderWxCouponCallbackDto;
import cn.com.duiba.quanyi.goods.service.api.param.SupplierOrderWxCouponCallbackPageParam;

import java.util.List;

/**
 * @author: LuHui
 * @date: 2024/2/29 17:28
 * @description:
 */
@AdvancedFeignClient
public interface RemoteSupplierOrderWxCouponCallbackService {

    /**
     * 根据券id查询
     * @param couponIdList
     * @return
     */
    List<SupplierOrderWxCouponCallbackDto> selectByCouponIds(List<String> couponIdList);

    /**
     * 分页查询不重复的批次ID
     *
     * @param pageParam  参数
     * @return 结果
     */
    List<String> selectDistinctPage(SupplierOrderWxCouponCallbackPageParam pageParam);

    /**
     * 分页查询不重复的批次ID集合
     *
     * @param pageParam  分页参数
     * @return 结果
     */
    Long selectDistinctCount(SupplierOrderWxCouponCallbackPageParam pageParam);
}
