package cn.com.duiba.quanyi.goods.service.api.remoteservice.order.supplier;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.order.supplier.SupplierOrderWxRedPacketDto;

import java.util.List;

/**
 * @author xuzhigang
 * @date 2024/7/11 16:56
 **/
@AdvancedFeignClient
public interface RemoteSupplierOrderWxRedPacketService {

    /**
     * 根据订单号查询
     *
     * @param orderNo 订单号
     * @return 供应商订单-微信红包扩展字段
     */
    List<SupplierOrderWxRedPacketDto> selectByOrderNo(String orderNo);

    /**
     * 根据订单号批量查询
     *
     * @param orderNos 订单号
     * @return 供应商订单-微信红包扩展字段
     */
    List<SupplierOrderWxRedPacketDto> selectByOrderNos(List<String> orderNos);
}
