package cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.virtual.alipay;

import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.virtual.VirtualBaseOrderRetryReq;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @author yangyukang
 * @date 2023/10/19
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class AlipayCountCoinsOrderRetryReq extends VirtualBaseOrderRetryReq {

    private static final long serialVersionUID = 2693483400405447041L;
    /**
     * 支付宝用户ID
     * user_id，logon_id，phone_id不能同时为空，优先级依次降低。
     * 注：UID为用户唯一标识，可通过授权方式获取，具体见产品文档。
     * 特殊可选，最大长度16
     */
    private String userId;

    /**
     * 支付宝用户ID
     * user_id，logon_id，phone_id不能同时为空，优先级依次降低。
     * 注：若手机号为非用户注册支付宝账号，则会发放失败。
     * 特殊可选，最大长度128
     */
    private String loginId;

    /**
     * 活动id，获取方式：调用方通过活动创建接口alipay.marketing.campaign.drawcamp.create 生成；联系支付宝运营同学获取（适用于支付宝平台活动，由合作伙伴调用触发）
     * 必选，最大长度64
     */
    private String actId;

    /**
     * 用户参与活动的手机号（如果是用户直接输入手机号的活动形式，该项必填，作为识别用户的依据）
     * 特殊可选，最大长度15
     */
    private String phone;

    /**
     * 支付宝分配给开发者的应用ID
     * 必选，最大长度32
     */
    private String appId;
}
