package cn.com.duiba.quanyi.goods.service.api.remoteservice.order.processor.virtual;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.BaseOrderCreateReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.virtual.km.CardSecretOrderCreateReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.virtual.km.CardSecretOrderRetryReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.BaseResult;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.OrderCreateResult;

/**
 * RemoteOrderProcessorCardSecretService
 */
@AdvancedFeignClient
public interface RemoteOrderProcessorCardSecretService {

    /**
     * 下单
     *
     * @param dto 下单所需参数
     * @return 下单结果
     */
    OrderCreateResult create(BaseOrderCreateReq<CardSecretOrderCreateReq> dto);

    /**
     * 异步重试
     *
     * @param dto 重试参数
     * @return 提交结果
     */
    BaseResult asyncRetry(CardSecretOrderRetryReq dto);

}
